<?php $__env->startSection('title','PCSOFT V4: Gestion Produit'); ?>
<?php $__env->startSection('content'); ?>
    <main class="col-sm-12 ml-sm-auto col-md-12 pt-0" style="text-decoration: none; margin-top: 5px;">
        <div class="col-12 col-sm-12 col-md-12 float-left">
            <div class="col-md-6 float-left">
                <h3 class="ml-5"><?php echo e(__('messages.RUPTURES DE STOCK')); ?></h3>
            </div>
            
        </div>

        <div class="col-12 col-sm-12 col-md-12">
            <div class="col-12 col-sm-8 col-md-8 float-left">
                <h3><?php echo e(__('messages.Liste des ruptures constatees')); ?></h3>
            </div>
            <div class="col-md- float-right">
                <button type="button" name="create_rupture" id="create_rupture" class="btn btn-success"><i class="fa fa-plus"></i> <?php echo e(__('messages.Saisir une nouvelle rupture')); ?></button>
            </div>
        </div>
        <br>
        <br>
        <div class="info-box">
            <div class="table-responsive">
                <table id="liste_rupture" class="table table-striped table-bordered data-table">
                    <thead>
                    <tr>
                        <th><?php echo e(__('messages.Date')); ?></th>
                        <th><?php echo e(__('messages.Produit')); ?></th>
                        <th><?php echo e(__('messages.Magasin')); ?></th>
                        <th><?php echo e(__('messages.Debut')); ?></th>
                        <th><?php echo e(__('messages.Fin')); ?></th>
                        <th><?php echo e(__('messages.Actions')); ?></th>
                    </tr>
                    </thead>
                </table>
            </div>

            <!--Ajouter un produit -->
            <div id="ruptureModal" class="modal fade" role="dialog">
                <div class="modal-dialog modal-dialog-scrollable modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title"><?php echo e(__('messages.Nouvelle Rupture')); ?></h4>
                        </div>
                        <div class="modal-body">
                            <span id="form_result"></span>
                            <form method="post" id="rupture_form" class="form-horizontal">
                                <?php echo csrf_field(); ?>
                                <table class="responsive-table table">
                                    <tr>
                                        <td>
                                            <div class="form-group">
                                                <label class="control-label col-md-12" ><?php echo e(__('messages.Date saisie')); ?> </label>
                                                <input type="date" name="date_rupture" id="date_rupture" class="form-control" required="required" value="<?php echo e($currentDate); ?>"/>
                                                <input type="hidden" name="rupture_id" id="rupture_id"/>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <?php echo Form::label(__('messages.Selectionner le produit')); ?>

                                                <?php echo Form::select('produit_id',$produits,null,['class'=>'form-control','id'=>'produit_id']); ?>

                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="form-group">
                                                <label class="control-label col-md-12" ><?php echo e(__('messages.Date debut rupture')); ?> </label>
                                                <input type="date" name="date_debut" id="date_debut" class="form-control" value="<?php echo e(date('d/m/Y')); ?>"/>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <label class="control-label col-md-12" ><?php echo e(__('messages.Date fin rupture')); ?> </label>
                                                <input type="date" name="date_fin" id="date_fin" class="form-control" required="required" value="<?php echo e($currentDate); ?>"/>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="form-group">
                                                <?php echo Form::label(__('messages.Selectionner le magasin')); ?>

                                                <?php echo Form::select('magasin_id',$magasins,null,['class'=>'form-control','id'=>'magasin_id']); ?>

                                            </div>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <div class="form-group" align="center">
                                                <input type="submit" name="action_button" id="action_button" class="btn btn-success" value="<?php echo e(__('messages.Enregistrer')); ?>" />
                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-group" align="center">
                                                <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-windows-close"></i><?php echo e(__('messages.Quitter')); ?></button>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <!--Supprimer le produit -->
            <main id="confirmModal" class="modal fade" role="dialog">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h2 class="modal-title"><?php echo e(__('messages.Confirmation')); ?></h2>
                        </div>
                        <div class="modal-body">
                            <h5 align="center" style="margin:0;"><?php echo e(__('messages.Etes vous sure de vouloir supprimer cette rupture')); ?>?</h5>
                        </div>
                        <div class="modal-footer">
                            <button type="button" name="ok_button" id="ok_button" class="btn btn-danger"><?php echo e(__('messages.Oui')); ?></button>
                            <button type="button" class="btn btn-primary" data-dismiss="modal"><?php echo e(__('messages.Annuler')); ?></button>
                        </div>
                    </div>
                </div>
            </main>

        </div>
    </main>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-js'); ?>
    <script>
        $(document).ready(function(){

            $('#liste_rupture').DataTable({
                processing: true,
                serverSide: true,
                ajax:{
                    url: "<?php echo e(route('rup.index')); ?>",
                },
                columns:[
                    {
                        data: 'date_rupture',
                        name: 'date_rupture'
                    },
                    {
                        data: 'nom_commercial',
                        name: 'nom_commercial'
                    },
                    {
                        data: 'libelle',
                        name: 'libelle'
                    },
                    {
                        data: 'date_debut',
                        name: 'date_debut'
                    },
                    {
                        data: 'date_fin',
                        name: 'date_fin'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false
                    }
                ]
            });

            $('#create_rupture').click(function(){
                $('.modal-title').text("<?php echo e(__('messages.Nouvelle Rupture')); ?>");
                $('#action_button').val("<?php echo e(__('messages.Enregistrer')); ?>");
                $('#rupture_id').val("");
                $('#date_rupture').val("");
                $('#date_debut').val("");
                $('#date_fin').val("");
                $('#form_result').html('');
                $('#ruptureModal').modal('show');
            });

            $('#rupture_form').on('submit', function(event){
                event.preventDefault();
                $.ajax({
                    url:"<?php echo e(route('rup.store')); ?>",
                    method:"POST",
                    data: new FormData(this),
                    contentType: false,
                    cache:false,
                    processData: false,
                    dataType:"json",
                    success:function(data)
                    {
                        var html = '';
                        if(data.errors)
                        {
                            html = '<div class="alert alert-danger">';
                            for(var count = 0; count < data.errors.length; count++)
                            {
                                html += '<p>' + data.errors[count] + '</p>';
                            }
                            html += '</div>';
                        }
                        if(data.error)
                        {
                            html = '<div class="alert alert-danger">' + data.error + '</div>';
                        }

                        if(data.success)
                        {
                            html = '<div class="alert alert-success">' + data.success + '</div>';
                            $('#rupture_form')[0].reset();
                            $('#liste_rupture').DataTable().ajax.reload();
                        }

                        $('#form_result').html(html);
                    }
                })
            });

            $(document).on('click', '.editer', function(){
                var id = $(this).attr('id');
                $('#form_result').html('');
                $.ajax({
                    url:"rup/"+id,
                    dataType:"json",
                    success:function(data){
                        $('#rupture_id').val(data.rupture_id);
                        $('#date_rupture').val(data.date_rupture);
                        $('#date_debut').val(data.date_debut);
                        $('#date_fin').val(data.date_fin);
                        $('#produit_id').val(data.produit_id);
                        $('#magasin_id').val(data.magasin_id);
                        $('.modal-title').text("<?php echo e(__('messages.Editer une rupture')); ?>");
                        $('#action_button').val("<?php echo e(__('messages.Valider')); ?>");
                        $('#ruptureModal').modal('show');
                    }
                })
            });


            var produit_id;
            $(document).on('click', '.delete', function(){
                produit_id = $(this).attr('id');
                $('.modal-title').text("<?php echo e(__('messages.Confirmer')); ?>");
                $('#ok_button').text('<?php echo e(__('messages.oui')); ?>');
                $('#confirmModal').modal('show');
            });

            $('#ok_button').click(function(){
                $.ajax({
                    url:"rup.delete/"+produit_id,
                    beforeSend:function(){
                        $('#ok_button').text('<?php echo e(__('messages.Suppression')); ?>...');
                    },
                    success:function(data)
                    {
                        setTimeout(function(){
                            $('#confirmModal').modal('hide');
                            $('#liste_rupture').DataTable().ajax.reload();
                        }, 200);
                    }
                })
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\gas_online\resources\views/rupture/index.blade.php ENDPATH**/ ?>